#include "meson-sample.h"

typedef struct _MesonSamplePrivate
{
  gchar *msg;
} MesonSamplePrivate;


G_DEFINE_TYPE_WITH_PRIVATE (MesonSample, meson_sample, G_TYPE_OBJECT)

enum {
  PROP_0,
  PROP_MSG,
  LAST_PROP
};

static GParamSpec *gParamSpecs [LAST_PROP];

/**
 * meson_sample_new:
 * @msg: The message to set.
 *
 * Allocates a new #MesonSample.
 *
 * Returns: (transfer full): a #MesonSample.
 */
MesonSample *
meson_sample_new (const gchar *msg)
{
  g_return_val_if_fail (msg != NULL, NULL);

  return g_object_new (MESON_TYPE_SAMPLE,
                       "message", msg,
                       NULL);
}

static void
meson_sample_finalize (GObject *object)
{
  MesonSamplePrivate *priv = meson_sample_get_instance_private ((MesonSample *) object);

  g_clear_pointer (&priv->msg, g_free);

  G_OBJECT_CLASS (meson_sample_parent_class)->finalize (object);
}

static void
meson_sample_get_property (GObject    *object,
                           guint       prop_id,
                           GValue     *value,
                           GParamSpec *pspec)
{
  MesonSamplePrivate *priv = meson_sample_get_instance_private ((MesonSample *) object);

  switch (prop_id)
    {
    case PROP_MSG:
      g_value_set_string (value, priv->msg);
      break;
    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
    }
}

static void
meson_sample_set_property (GObject      *object,
                           guint         prop_id,
                           const GValue *value,
                           GParamSpec   *pspec)
{
  MesonSamplePrivate *priv = meson_sample_get_instance_private ((MesonSample *) object);

  switch (prop_id)
    {
    case PROP_MSG:
      priv->msg = g_value_dup_string (value);
      break;
    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
    }
}

static void
meson_sample_class_init (MesonSampleClass *klass)
{
  GObjectClass *object_class = G_OBJECT_CLASS (klass);

  object_class->finalize = meson_sample_finalize;
  object_class->get_property = meson_sample_get_property;
  object_class->set_property = meson_sample_set_property;

  gParamSpecs [PROP_MSG] =
    g_param_spec_string ("message",
                         "Message",
                         "The message to print.",
                         NULL,
                         (G_PARAM_READWRITE |
                          G_PARAM_CONSTRUCT_ONLY |
                          G_PARAM_STATIC_STRINGS));

  g_object_class_install_properties (object_class, LAST_PROP, gParamSpecs);
}

static void
meson_sample_init (MesonSample *self)
{
}

/**
 * meson_sample_print_message:
 * @self: a #MesonSample.
 *
 * Prints the message.
 *
 */
void
meson_sample_print_message (MesonSample *self)
{
  MesonSamplePrivate *priv;

  g_return_if_fail (MESON_IS_SAMPLE (self));

  priv = meson_sample_get_instance_private (self);

  g_print ("Message: %s\n", priv->msg);
}
